package demo.module;

import java.io.File;

import netsdk.lib.DeviceSdk;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.lib.ToolKits;
import netsdk.struct.*;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.IntByReference;
/**
 * 登陆接口实现
 * 主要有 ：初始化、登陆、登出功能
 */
public class LoginModule {

	public static DeviceSdk netsdk = DeviceSdk.INSTANCE;

	
	// 设备信息
	public static LPNET_SDK_DEVICEINFO.ByReference m_stDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
	
	// 登陆句柄
	public static NativeLong m_hLoginHandle = new NativeLong(0);   
	
	private static boolean bInit    = false;
	
	/**
	 * \if ENGLISH_LANG
	 * Init
	 * \else
	 * 初始化
	 * \endif
	 */
	public static boolean init() {				
		bInit = netsdk.NET_SDK_Init();
		if(!bInit) {
			System.out.println("Initialize SDK failed");
			return false;
		}	
		boolean ret = netsdk.NET_SDK_SetLogToFile(true,"D:\\A文档",false,4);	
		// 设置断线重连回调接口，设置过断线重连成功回调函数后，当设备出现断线情况，SDK内部会自动进行重连操作
		// 此操作为可选操作，但建议用户进行设置
	    
		//设置登录超时时间和尝试次数，可选
		int waitTime = 5000; //登录请求响应超时时间设置为5S
		int tryTimes = 1;    //登录时尝试建立链接1次
		netsdk.NET_SDK_SetConnectTime(waitTime, tryTimes);
		
		// 设置更多网络参数，NET_PARAM的nWaittime，nConnectTryNum成员与CLIENT_SetConnectTime 
		// 接口设置的登录设备超时时间和尝试次数意义相同,可选
		int nConnectTime = 10000;      // 登录时尝试建立链接的超时时间
		netsdk.NET_SDK_SetReconnect(nConnectTime, true);	
		
		return true;
	}
	
	/**
	 * \if ENGLISH_LANG
	 * CleanUp
	 * \else
	 * 清除环境
	 * \endif
	 */
	public static void cleanup() {			
		if(bInit) {
			netsdk.NET_SDK_Cleanup();
		}
	}

	/**
	 * \if ENGLISH_LANG
	 * Login Device
	 * \else
	 * 登录设备
	 * \endif
	 */
	public static boolean login(String m_strIp, int m_nPort, String m_strUser, String m_strPassword) {	
		IntByReference nError = new IntByReference(0);
		m_hLoginHandle = netsdk.NET_SDK_LoginEx(m_strIp, m_nPort, m_strUser, m_strPassword, m_stDeviceInfo, ErrorCodeAndConst.NET_SDK_CONNECT_TCP, "");
		if(m_hLoginHandle.longValue() < 1) {
			System.err.printf("Login Device[%s] Port[%d]Failed. %s\n", m_strIp, m_nPort, ToolKits.getErrorCodePrint());
		} else {
			System.out.println("Login Success [ " + m_strIp + " ]");
		}	
		
		return m_hLoginHandle.longValue() < 1? false:true;
	}
	public static boolean loginEx(String m_strIp, int m_nPort, String sn, String m_strUser, String m_strPassword) {	
		IntByReference nError = new IntByReference(0);
		m_hLoginHandle = netsdk.NET_SDK_LoginEx(m_strIp, m_nPort, m_strUser, m_strPassword, m_stDeviceInfo, ErrorCodeAndConst.NET_SDK_CONNECT_NAT, sn);//NET_SDK_CONNECT_NAT or  //NET_SDK_CONNECT_NAT20(First time NET_SDK_SetNat2Addr)
		if(m_hLoginHandle.longValue() < 1) {
			System.err.printf("Login Device[%s] Port[%d]Failed. %s\n", m_strIp, m_nPort, ToolKits.getErrorCodePrint());
		} else {
			System.out.println("Login Success [ " + m_strIp + " ]");
		}	
		
		return m_hLoginHandle.longValue() < 1? false:true;
	}
	/**
	 * \if ENGLISH_LANG
	 * Logout Device
	 * \else
	 * 登出设备
	 * \endif
	 */
	public static boolean logout() {
		if(m_hLoginHandle.longValue() == 0) {
			return false;
		}
		
		boolean bRet = netsdk.NET_SDK_Logout(m_hLoginHandle);
		if(bRet) {			
			m_hLoginHandle.setValue(0);	
		}
		
		return bRet;
	}
}
